with country as
(
    select
        country_code_two_letter as country_code,
        country_code_three_letter,
        country_code_numeric,
        country_name
    from warehouse.dim_country
),
asns as
(
    select esp.client_asn
    from tahoe.edge_segment_playlist esp
    where date >= date_trunc('day', getdate() - interval '60 days')
    group by esp.client_asn
),
asn_country_60_days as
(
     select
        a.client_asn,
        a.country_code,
        a.count_asn,
        country.country_name,
        '60-50' as fragment
    from
    (
        select
            esp.client_asn,
            esp.client_country as country_code,
            row_number() over (partition by client_asn order by count(*) desc) as sort,
            count(*) as count_asn
        from tahoe.edge_segment_playlist esp
        where
            date >= date_trunc('day', getdate() - interval '60 days')
            and date < date_trunc('day', getdate() - interval '50 days')
        group by
            esp.client_asn,
            esp.client_country
    ) as a
    left join country
    on a.country_code = country.country_code
    where sort = 1
),
asn_country_50_days as
(
     select
        a.client_asn,
        a.country_code,
        a.count_asn,
        country.country_name,
        '50-40' as fragment
    from
    (
        select
            esp.client_asn,
            esp.client_country as country_code,
            row_number() over (partition by client_asn order by count(*) desc) as sort,
            count(*) as count_asn
        from tahoe.edge_segment_playlist esp
        where
            date >= date_trunc('day', getdate() - interval '50 days')
            and date < date_trunc('day', getdate() - interval '40 days')
        group by
            esp.client_asn,
            esp.client_country
    ) as a
    left join country
    on a.country_code = country.country_code
    where sort = 1
),
asn_country_40_days as
(
   select
        a.client_asn,
        a.country_code,
        a.count_asn,
        country.country_name,
        '40-30' as fragment
    from
    (
        select
            esp.client_asn,
            esp.client_country as country_code,
            row_number() over (partition by client_asn order by count(*) desc) as sort,
            count(*) as count_asn
        from tahoe.edge_segment_playlist esp
        where
            date >= date_trunc('day', getdate() - interval '40 days')
            and date < date_trunc('day', getdate() - interval '30 days')
        group by
            esp.client_asn,
            esp.client_country
    ) as a
    left join country
    on a.country_code = country.country_code
    where sort = 1
),
asn_country_30_days as
(
   select
        a.client_asn,
        a.country_code,
        a.count_asn,
        country.country_name,
        '30-20' as fragment
    from
    (
        select
            esp.client_asn,
            esp.client_country as country_code,
            row_number() over (partition by client_asn order by count(*) desc) as sort,
            count(*) as count_asn
        from tahoe.edge_segment_playlist esp
        where
            date >= date_trunc('day', getdate() - interval '30 days')
            and date < date_trunc('day', getdate() - interval '20 days')
        group by
            esp.client_asn,
            esp.client_country
    ) as a
    left join country
    on a.country_code = country.country_code
    where sort = 1
),
asn_country_20_days as
(
   select
        a.client_asn,
        a.country_code,
        a.count_asn,
        country.country_name,
        '20-10' as fragment
    from
    (
        select
            esp.client_asn,
            esp.client_country as country_code,
            row_number() over (partition by client_asn order by count(*) desc) as sort,
            count(*) as count_asn
        from tahoe.edge_segment_playlist esp
        where
            date >= date_trunc('day', getdate() - interval '20 days')
            and date < date_trunc('day', getdate() - interval '10 days')
        group by
            esp.client_asn,
            esp.client_country
    ) as a
    left join country
    on a.country_code = country.country_code
    where sort = 1
),
asn_country_10_days as
(
   select
        a.client_asn,
        a.country_code,
        a.count_asn,
        country.country_name,
        '10-0' as fragment
    from
    (
        select
            esp.client_asn,
            esp.client_country as country_code,
            row_number() over (partition by client_asn order by count(*) desc) as sort,
            count(*) as count_asn
        from tahoe.edge_segment_playlist esp
        where
            date >= date_trunc('day', getdate() - interval '10 days')
            and date < date_trunc('day', getdate() - interval '0 days')
        group by
            esp.client_asn,
            esp.client_country
    ) as a
    left join country
    on a.country_code = country.country_code
    where sort = 1
)
select
    asns.client_asn,
    asn_country_60_days.fragment,
    asn_country_60_days.country_code,
    asn_country_60_days.country_name,
    asn_country_60_days.count_asn
from asns
inner join asn_country_60_days
    on asns.client_asn = asn_country_60_days.client_asn

union all

select
    asns.client_asn,
    asn_country_50_days.fragment,
    asn_country_50_days.country_code,
    asn_country_50_days.country_name,
    asn_country_50_days.count_asn
from asns
inner join asn_country_50_days
    on asns.client_asn = asn_country_50_days.client_asn

union all

select
    asns.client_asn,
    asn_country_40_days.fragment,
    asn_country_40_days.country_code,
    asn_country_40_days.country_name,
    asn_country_40_days.count_asn
from asns
inner join asn_country_40_days
    on asns.client_asn = asn_country_40_days.client_asn

union all

select
    asns.client_asn,
    asn_country_30_days.fragment,
    asn_country_30_days.country_code,
    asn_country_30_days.country_name,
    asn_country_30_days.count_asn
from asns
inner join asn_country_30_days
    on asns.client_asn = asn_country_30_days.client_asn

union all

select
    asns.client_asn,
    asn_country_20_days.fragment,
    asn_country_20_days.country_code,
    asn_country_20_days.country_name,
    asn_country_20_days.count_asn
from asns
inner join asn_country_20_days
    on asns.client_asn = asn_country_20_days.client_asn

union all

select
    asns.client_asn,
    asn_country_10_days.fragment,
    asn_country_10_days.country_code,
    asn_country_10_days.country_name,
    asn_country_10_days.count_asn
from asns
inner join asn_country_10_days
    on asns.client_asn = asn_country_10_days.client_asn